#!/bin/bash

# --- Step 1: Force administrator rights ---
if [ "$EUID" -ne 0 ]; then
  echo "This script must be run as root."
  echo "Please run it again using: sudo ./install.sh"
  exit 1
fi

echo "Starting installing Wegstr CNC..."

# --- Step 2: Detect paths and define targets ---
# Get the absolute path to the script's directory (the source 'Wegstr' folder)
SOURCE_DIR=$(dirname "$(readlink -f "$0")")

# Target directory for installation
INSTALL_DIR="/opt/Wegstr"

# Target .desktop file (system-wide, for all users)
DESKTOP_FILE="/usr/share/applications/wegstr.desktop"

# --- Step 3: Copy application files ---
echo "Copying application files to $INSTALL_DIR..."
# Remove old installation if it exists
if [ -d "$INSTALL_DIR" ]; then
    echo "Removing previous version..."
    rm -rf "$INSTALL_DIR"
fi
# Copy the entire source directory to /opt
cp -rp "$SOURCE_DIR" "$INSTALL_DIR"

# --- Step 4: Set permissions ---
echo "Setting permissions..."
chmod -R 755 "$INSTALL_DIR"

# --- Step 5: Create .desktop file ---
# Paths now point to the new, shared location in /opt
EXECUTABLE_FILE="$INSTALL_DIR/bin/Wegstr"
ICON_FILE="$INSTALL_DIR/lib/app/icon.png"

echo "Creating application menu launcher..."
cat > "$DESKTOP_FILE" <<EOF
[Desktop Entry]
Version=3.2.0
Type=Application
Name=Wegstr CNC
Comment=Wegstr CNC controlling software
Exec=$EXECUTABLE_FILE
Icon=$ICON_FILE
Terminal=false
Categories=Utility;Application;
StartupWMClass=com-cnc-wegstr-Wegstr
EOF

# --- Step 6: Update application database ---
echo "Updating application database..."
update-desktop-database /usr/share/applications/

echo "✔ Installation successfully completed!"
echo "You can now find 'Wegstr CNC' controlling software in your application menu." 
