#!/bin/bash

# --- Step 1: Force administrator rights ---
if [ "$EUID" -ne 0 ]; then
  echo "This script must be run as root."
  echo "Please run it again using: sudo ./uninstall.sh"
  exit 1
fi

echo "Starting uninstalling Wegstr CNC..."

# --- Step 2: Define paths ---
# These paths must match the ones used in the installer
INSTALL_DIR="/opt/Wegstr"
DESKTOP_FILE="/usr/share/applications/wegstr.desktop"

# --- Step 3: Remove application files ---
echo "Removing application files from $INSTALL_DIR..."
if [ -d "$INSTALL_DIR" ]; then
    rm -rf "$INSTALL_DIR"
else
    echo "Directory $INSTALL_DIR not found. Skipping."
fi

# --- Step 4: Remove menu launcher ---
echo "Removing application menu launcher..."
if [ -f "$DESKTOP_FILE" ]; then
    rm -f "$DESKTOP_FILE"
else
    echo "Launcher file $DESKTOP_FILE not found. Skipping."
fi

# --- Step 5: Update application database ---
# This tells the system to refresh the application menu
echo "Updating application database..."
update-desktop-database /usr/share/applications/

echo "✔ Uninstallation successfully completed." 
